/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;

public class DuplicateInitializerInvocationFixer
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final Logger logger = LogManager.getLogger(DuplicateInitializerInvocationFixer.class);
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private String descriptor;
    private int descriptorLengthDelta;

    public DuplicateInitializerInvocationFixer() {
        this(null);
    }

    public DuplicateInitializerInvocationFixer(InstructionVisitor extraAddedInstructionVisitor) {
        this.extraAddedInstructionVisitor = extraAddedInstructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -73) {
            this.descriptorLengthDelta = 0;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.descriptorLengthDelta > 0) {
                SimpleInstruction extraInstruction = new SimpleInstruction(this.descriptorLengthDelta == 1 ? (byte)3 : 1);
                this.codeAttributeEditor.insertBeforeInstruction(offset, extraInstruction);
                logger.debug("  [{}.{}{}] Inserting {} before {}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz), (Object)((Object)extraInstruction).toString(), (Object)constantInstruction.toString(offset));
                if (this.extraAddedInstructionVisitor != null) {
                    ((Instruction)extraInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                }
            }
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        if (anyMethodrefConstant.getName(clazz).equals("<init>")) {
            this.descriptor = anyMethodrefConstant.getType(clazz);
            anyMethodrefConstant.referencedMethodAccept(this);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.descriptorLengthDelta = programMethod.getDescriptor(programClass).length() - this.descriptor.length();
        if (this.descriptorLengthDelta > 0) {
            logger.debug("DuplicateInitializerInvocationFixer:");
            logger.debug("  [{}.{}{}] ({}) referenced by:", (Object)programClass.getName(), (Object)programMethod.getName(programClass), (Object)programMethod.getDescriptor(programClass), (Object)ClassUtil.externalClassAccessFlags(programMethod.getAccessFlags()));
        }
    }
}

