// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package fcgi_app

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceFCGIAppOKCode is the HTTP code returned for type ReplaceFCGIAppOK
const ReplaceFCGIAppOKCode int = 200

/*
ReplaceFCGIAppOK Application replaced

swagger:response replaceFcgiAppOK
*/
type ReplaceFCGIAppOK struct {

	/*
	  In: Body
	*/
	Payload *models.FCGIApp `json:"body,omitempty"`
}

// NewReplaceFCGIAppOK creates ReplaceFCGIAppOK with default headers values
func NewReplaceFCGIAppOK() *ReplaceFCGIAppOK {

	return &ReplaceFCGIAppOK{}
}

// WithPayload adds the payload to the replace Fcgi app o k response
func (o *ReplaceFCGIAppOK) WithPayload(payload *models.FCGIApp) *ReplaceFCGIAppOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Fcgi app o k response
func (o *ReplaceFCGIAppOK) SetPayload(payload *models.FCGIApp) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFCGIAppOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFCGIAppAcceptedCode is the HTTP code returned for type ReplaceFCGIAppAccepted
const ReplaceFCGIAppAcceptedCode int = 202

/*
ReplaceFCGIAppAccepted Configuration change accepted and reload requested

swagger:response replaceFcgiAppAccepted
*/
type ReplaceFCGIAppAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.FCGIApp `json:"body,omitempty"`
}

// NewReplaceFCGIAppAccepted creates ReplaceFCGIAppAccepted with default headers values
func NewReplaceFCGIAppAccepted() *ReplaceFCGIAppAccepted {

	return &ReplaceFCGIAppAccepted{}
}

// WithReloadID adds the reloadId to the replace Fcgi app accepted response
func (o *ReplaceFCGIAppAccepted) WithReloadID(reloadID string) *ReplaceFCGIAppAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Fcgi app accepted response
func (o *ReplaceFCGIAppAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Fcgi app accepted response
func (o *ReplaceFCGIAppAccepted) WithPayload(payload *models.FCGIApp) *ReplaceFCGIAppAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Fcgi app accepted response
func (o *ReplaceFCGIAppAccepted) SetPayload(payload *models.FCGIApp) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFCGIAppAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFCGIAppBadRequestCode is the HTTP code returned for type ReplaceFCGIAppBadRequest
const ReplaceFCGIAppBadRequestCode int = 400

/*
ReplaceFCGIAppBadRequest Bad request

swagger:response replaceFcgiAppBadRequest
*/
type ReplaceFCGIAppBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFCGIAppBadRequest creates ReplaceFCGIAppBadRequest with default headers values
func NewReplaceFCGIAppBadRequest() *ReplaceFCGIAppBadRequest {

	return &ReplaceFCGIAppBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Fcgi app bad request response
func (o *ReplaceFCGIAppBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceFCGIAppBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Fcgi app bad request response
func (o *ReplaceFCGIAppBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Fcgi app bad request response
func (o *ReplaceFCGIAppBadRequest) WithPayload(payload *models.Error) *ReplaceFCGIAppBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Fcgi app bad request response
func (o *ReplaceFCGIAppBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFCGIAppBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceFCGIAppNotFoundCode is the HTTP code returned for type ReplaceFCGIAppNotFound
const ReplaceFCGIAppNotFoundCode int = 404

/*
ReplaceFCGIAppNotFound The specified resource was not found

swagger:response replaceFcgiAppNotFound
*/
type ReplaceFCGIAppNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFCGIAppNotFound creates ReplaceFCGIAppNotFound with default headers values
func NewReplaceFCGIAppNotFound() *ReplaceFCGIAppNotFound {

	return &ReplaceFCGIAppNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Fcgi app not found response
func (o *ReplaceFCGIAppNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceFCGIAppNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Fcgi app not found response
func (o *ReplaceFCGIAppNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Fcgi app not found response
func (o *ReplaceFCGIAppNotFound) WithPayload(payload *models.Error) *ReplaceFCGIAppNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Fcgi app not found response
func (o *ReplaceFCGIAppNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFCGIAppNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceFCGIAppDefault General Error

swagger:response replaceFcgiAppDefault
*/
type ReplaceFCGIAppDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceFCGIAppDefault creates ReplaceFCGIAppDefault with default headers values
func NewReplaceFCGIAppDefault(code int) *ReplaceFCGIAppDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceFCGIAppDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace FCGI app default response
func (o *ReplaceFCGIAppDefault) WithStatusCode(code int) *ReplaceFCGIAppDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace FCGI app default response
func (o *ReplaceFCGIAppDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace FCGI app default response
func (o *ReplaceFCGIAppDefault) WithConfigurationVersion(configurationVersion string) *ReplaceFCGIAppDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace FCGI app default response
func (o *ReplaceFCGIAppDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace FCGI app default response
func (o *ReplaceFCGIAppDefault) WithPayload(payload *models.Error) *ReplaceFCGIAppDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace FCGI app default response
func (o *ReplaceFCGIAppDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceFCGIAppDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
