// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple nvptx64-nvidia-cuda -emit-llvm \
// RUN:   -fvisibility=hidden -o - %s | FileCheck %s --check-prefix=NVPTX
// RUN: %clang_cc1 -triple amdgcn-amd-amdhsa -emit-llvm \
// RUN:   -fvisibility=hidden -o - %s | FileCheck %s --check-prefix=AMDGPU

// NVPTX-LABEL: define hidden void @_Z1fPv(
// NVPTX-SAME: ptr noundef [[P:%.*]]) #[[ATTR0:[0-9]+]] {
// NVPTX-NEXT:  [[ENTRY:.*:]]
// NVPTX-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    ret void
//
// AMDGPU-LABEL: define hidden void @_Z1fPv(
// AMDGPU-SAME: ptr noundef [[P:%.*]]) #[[ATTR0:[0-9]+]] {
// AMDGPU-NEXT:  [[ENTRY:.*:]]
// AMDGPU-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-NEXT:    [[P_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P_ADDR]] to ptr
// AMDGPU-NEXT:    store ptr [[P]], ptr [[P_ADDR_ASCAST]], align 8
// AMDGPU-NEXT:    ret void
//
void f(void *p) {}

// NVPTX-LABEL: define hidden void @_Z2p1Pv(
// NVPTX-SAME: ptr noundef [[P:%.*]]) #[[ATTR0]] {
// NVPTX-NEXT:  [[ENTRY:.*:]]
// NVPTX-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    call void @_Z1fPv(ptr noundef [[TMP0]]) #[[ATTR1:[0-9]+]]
// NVPTX-NEXT:    ret void
//
// AMDGPU-LABEL: define hidden void @_Z2p1Pv(
// AMDGPU-SAME: ptr noundef [[P:%.*]]) #[[ATTR0]] {
// AMDGPU-NEXT:  [[ENTRY:.*:]]
// AMDGPU-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-NEXT:    [[P_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P_ADDR]] to ptr
// AMDGPU-NEXT:    store ptr [[P]], ptr [[P_ADDR_ASCAST]], align 8
// AMDGPU-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR_ASCAST]], align 8
// AMDGPU-NEXT:    call void @_Z1fPv(ptr noundef [[TMP0]]) #[[ATTR1:[0-9]+]]
// AMDGPU-NEXT:    ret void
//
void p1(void [[clang::address_space(0)]] * p) { f(p); }
// NVPTX-LABEL: define hidden noundef ptr @_Z2p2PU3AS3v(
// NVPTX-SAME: ptr addrspace(3) noundef [[P:%.*]]) #[[ATTR0]] {
// NVPTX-NEXT:  [[ENTRY:.*:]]
// NVPTX-NEXT:    [[P_ADDR:%.*]] = alloca ptr addrspace(3), align 8
// NVPTX-NEXT:    store ptr addrspace(3) [[P]], ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(3) [[TMP0]] to ptr
// NVPTX-NEXT:    ret ptr [[TMP1]]
//
// AMDGPU-LABEL: define hidden noundef ptr @_Z2p2PU3AS3v(
// AMDGPU-SAME: ptr addrspace(3) noundef [[P:%.*]]) #[[ATTR0]] {
// AMDGPU-NEXT:  [[ENTRY:.*:]]
// AMDGPU-NEXT:    [[RETVAL:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-NEXT:    [[P_ADDR:%.*]] = alloca ptr addrspace(3), align 4, addrspace(5)
// AMDGPU-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// AMDGPU-NEXT:    [[P_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P_ADDR]] to ptr
// AMDGPU-NEXT:    store ptr addrspace(3) [[P]], ptr [[P_ADDR_ASCAST]], align 4
// AMDGPU-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr [[P_ADDR_ASCAST]], align 4
// AMDGPU-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(3) [[TMP0]] to ptr
// AMDGPU-NEXT:    ret ptr [[TMP1]]
//
void *p2(void [[clang::address_space(3)]] * p) { return p; }
// NVPTX-LABEL: define hidden noundef ptr @_Z2p3PU3AS3v(
// NVPTX-SAME: ptr addrspace(3) noundef [[P:%.*]]) #[[ATTR0]] {
// NVPTX-NEXT:  [[ENTRY:.*:]]
// NVPTX-NEXT:    [[P_ADDR:%.*]] = alloca ptr addrspace(3), align 8
// NVPTX-NEXT:    store ptr addrspace(3) [[P]], ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(3) [[TMP0]] to ptr
// NVPTX-NEXT:    ret ptr [[TMP1]]
//
// AMDGPU-LABEL: define hidden noundef ptr @_Z2p3PU3AS3v(
// AMDGPU-SAME: ptr addrspace(3) noundef [[P:%.*]]) #[[ATTR0]] {
// AMDGPU-NEXT:  [[ENTRY:.*:]]
// AMDGPU-NEXT:    [[RETVAL:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-NEXT:    [[P_ADDR:%.*]] = alloca ptr addrspace(3), align 4, addrspace(5)
// AMDGPU-NEXT:    [[RETVAL_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[RETVAL]] to ptr
// AMDGPU-NEXT:    [[P_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P_ADDR]] to ptr
// AMDGPU-NEXT:    store ptr addrspace(3) [[P]], ptr [[P_ADDR_ASCAST]], align 4
// AMDGPU-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr [[P_ADDR_ASCAST]], align 4
// AMDGPU-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(3) [[TMP0]] to ptr
// AMDGPU-NEXT:    ret ptr [[TMP1]]
//
void *p3(void [[clang::address_space(3)]] * p) { return p; }

struct S {
  S() = default;
  ~S() = default;
  void foo() {}
};

S s1;
S [[clang::address_space(1)]] s2;
S [[clang::address_space(3)]] s3;

template <typename Ty> void foo(Ty *) {}

// NVPTX-LABEL: define hidden void @_Z2t1Pv(
// NVPTX-SAME: ptr noundef [[P:%.*]]) #[[ATTR0]] {
// NVPTX-NEXT:  [[ENTRY:.*:]]
// NVPTX-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// NVPTX-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    call void @_Z3fooIvEvPT_(ptr noundef [[TMP0]]) #[[ATTR1]]
// NVPTX-NEXT:    ret void
//
// AMDGPU-LABEL: define hidden void @_Z2t1Pv(
// AMDGPU-SAME: ptr noundef [[P:%.*]]) #[[ATTR0]] {
// AMDGPU-NEXT:  [[ENTRY:.*:]]
// AMDGPU-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGPU-NEXT:    [[P_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P_ADDR]] to ptr
// AMDGPU-NEXT:    store ptr [[P]], ptr [[P_ADDR_ASCAST]], align 8
// AMDGPU-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR_ASCAST]], align 8
// AMDGPU-NEXT:    call void @_Z3fooIvEvPT_(ptr noundef [[TMP0]]) #[[ATTR1]]
// AMDGPU-NEXT:    ret void
//
void t1(void *p) { foo(p); }
// NVPTX-LABEL: define hidden void @_Z2t3PU3AS3v(
// NVPTX-SAME: ptr addrspace(3) noundef [[P:%.*]]) #[[ATTR0]] {
// NVPTX-NEXT:  [[ENTRY:.*:]]
// NVPTX-NEXT:    [[P_ADDR:%.*]] = alloca ptr addrspace(3), align 8
// NVPTX-NEXT:    store ptr addrspace(3) [[P]], ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr [[P_ADDR]], align 8
// NVPTX-NEXT:    call void @_Z3fooIU3AS3vEvPT_(ptr addrspace(3) noundef [[TMP0]]) #[[ATTR1]]
// NVPTX-NEXT:    ret void
//
// AMDGPU-LABEL: define hidden void @_Z2t3PU3AS3v(
// AMDGPU-SAME: ptr addrspace(3) noundef [[P:%.*]]) #[[ATTR0]] {
// AMDGPU-NEXT:  [[ENTRY:.*:]]
// AMDGPU-NEXT:    [[P_ADDR:%.*]] = alloca ptr addrspace(3), align 4, addrspace(5)
// AMDGPU-NEXT:    [[P_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P_ADDR]] to ptr
// AMDGPU-NEXT:    store ptr addrspace(3) [[P]], ptr [[P_ADDR_ASCAST]], align 4
// AMDGPU-NEXT:    [[TMP0:%.*]] = load ptr addrspace(3), ptr [[P_ADDR_ASCAST]], align 4
// AMDGPU-NEXT:    call void @_Z3fooIU3AS3vEvPT_(ptr addrspace(3) noundef [[TMP0]]) #[[ATTR1]]
// AMDGPU-NEXT:    ret void
//
void t3(void [[clang::address_space(3)]] *p) { foo(p); }
