﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codedeploy/model/DeleteDeploymentConfigRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CodeDeploy::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteDeploymentConfigRequest::SerializePayload() const {
  JsonValue payload;

  if (m_deploymentConfigNameHasBeenSet) {
    payload.WithString("deploymentConfigName", m_deploymentConfigName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteDeploymentConfigRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "CodeDeploy_20141006.DeleteDeploymentConfig"));
  return headers;
}
