// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// FCGILogStderr Enables logging of STDERR messages that the FastCGI application reports.
// It is an optional setting. By default, HAProxy Enterprise ignores STDERR messages.
//
// swagger:model fcgiLogStderr
type FCGILogStderr struct {

	// address
	Address string `json:"address,omitempty"`

	// Facility
	Facility string `json:"facility,omitempty"`

	// Format
	Format string `json:"format,omitempty"`

	// Global
	Global bool `json:"global,omitempty"`

	// Length
	Len int64 `json:"len,omitempty"`

	// Level
	Level string `json:"level,omitempty"`

	// Minimum level
	Minlevel string `json:"minlevel,omitempty"`

	// sample
	Sample *FCGILogStderrSample `json:"sample,omitempty"`
}

// Validate validates this fcgi log stderr
func (m *FCGILogStderr) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSample(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FCGILogStderr) validateSample(formats strfmt.Registry) error {
	if swag.IsZero(m.Sample) { // not required
		return nil
	}

	if m.Sample != nil {
		if err := m.Sample.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sample")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sample")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcgi log stderr based on the context it is used
func (m *FCGILogStderr) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSample(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FCGILogStderr) contextValidateSample(ctx context.Context, formats strfmt.Registry) error {

	if m.Sample != nil {

		if swag.IsZero(m.Sample) { // not required
			return nil
		}

		if err := m.Sample.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("sample")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("sample")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *FCGILogStderr) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FCGILogStderr) UnmarshalBinary(b []byte) error {
	var res FCGILogStderr
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// FCGILogStderrSample Sample
//
// swagger:model FCGILogStderrSample
type FCGILogStderrSample struct {

	// Range
	// Required: true
	Ranges *string `json:"ranges"`

	// Size
	// Required: true
	Size *int64 `json:"size"`
}

// Validate validates this FCGI log stderr sample
func (m *FCGILogStderrSample) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRanges(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FCGILogStderrSample) validateRanges(formats strfmt.Registry) error {

	if err := validate.Required("sample"+"."+"ranges", "body", m.Ranges); err != nil {
		return err
	}

	return nil
}

func (m *FCGILogStderrSample) validateSize(formats strfmt.Registry) error {

	if err := validate.Required("sample"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this FCGI log stderr sample based on context it is used
func (m *FCGILogStderrSample) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *FCGILogStderrSample) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FCGILogStderrSample) UnmarshalBinary(b []byte) error {
	var res FCGILogStderrSample
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
