import React from 'react';
import type { Direction, DraggableId, DroppableId } from 'react-beautiful-dnd';
/**
 * The virtual placeholder exists specifically for virtual lists,
 * to ensure that the injected placeholder is correctly positioned.
 *
 * Standard placeholders are rendered as siblings, and do not need explicit
 * positioning.
 *
 * Because virtual placeholders are injected through a portal, they need to be
 * absolutely positioned so that they cover the gap left by the dragging item.
 *
 * This placeholder is important because it acts as the drop target for the
 * dragging item.
 */
export declare function VirtualPlaceholder({ draggableId, droppableId, type, direction, isDropDisabled, }: {
    draggableId: DraggableId;
    droppableId: DroppableId;
    type: string;
    direction: Direction;
    isDropDisabled: boolean;
}): React.JSX.Element;
